/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.dynamic;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.netty.handler.codec.DecoderException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3518;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.modifiers.util.ModifierLevelDisplay;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class ComposableModifier
extends Modifier {
    private final ModifierLevelDisplay levelDisplay;
    private final TooltipDisplay tooltipDisplay;
    private final int priority;
    private final List<ModifierModule.ModuleWithHooks> modules;
    public static GenericLoaderRegistry.IGenericLoader<ComposableModifier> LOADER = new GenericLoaderRegistry.IGenericLoader<ComposableModifier>(){

        @Override
        public ComposableModifier deserialize(JsonObject json) {
            ModifierLevelDisplay level_display = ModifierLevelDisplay.LOADER.getAndDeserialize(json, "level_display");
            TooltipDisplay tooltipDisplay = TooltipDisplay.ALWAYS;
            if (json.has("tooltip_display")) {
                tooltipDisplay = JsonHelper.getAsEnum(json, "tooltip_display", TooltipDisplay.class);
            }
            List<ModifierModule.ModuleWithHooks> modules = JsonHelper.parseList(json, "modules", ModifierModule.ModuleWithHooks::deserialize);
            int priority = json.has("priority") ? class_3518.method_15260((JsonObject)json, (String)"priority") : ComposableModifier.computePriority(modules);
            try {
                return new ComposableModifier(level_display, tooltipDisplay, priority, modules);
            }
            catch (IllegalArgumentException e) {
                throw new JsonSyntaxException(e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public void serialize(ComposableModifier object, JsonObject json) {
            json.add("level_display", ModifierLevelDisplay.LOADER.serialize(object.levelDisplay));
            json.addProperty("tooltip_display", object.tooltipDisplay.name().toLowerCase(Locale.ROOT));
            if (object.priority != Integer.MIN_VALUE) {
                json.addProperty("priority", (Number)object.priority);
            }
            JsonArray modules = new JsonArray();
            for (ModifierModule.ModuleWithHooks module : object.modules) {
                modules.add((JsonElement)module.serialize());
            }
            json.add("modules", (JsonElement)modules);
        }

        @Override
        public ComposableModifier fromNetwork(class_2540 buffer) {
            ModifierLevelDisplay levelDisplay = ModifierLevelDisplay.LOADER.fromNetwork(buffer);
            TooltipDisplay tooltipDisplay = (TooltipDisplay)buffer.method_10818(TooltipDisplay.class);
            int priority = buffer.readInt();
            int moduleCount = buffer.method_10816();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < moduleCount; ++i) {
                builder.add((Object)ModifierModule.ModuleWithHooks.fromNetwork(buffer));
            }
            try {
                return new ComposableModifier(levelDisplay, tooltipDisplay, priority, (List<ModifierModule.ModuleWithHooks>)builder.build());
            }
            catch (IllegalArgumentException e) {
                throw new DecoderException(e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public void toNetwork(ComposableModifier object, class_2540 buffer) {
            ModifierLevelDisplay.LOADER.toNetwork(object.levelDisplay, buffer);
            buffer.method_10817((Enum)object.tooltipDisplay);
            buffer.writeInt(object.priority);
            buffer.method_10804(object.modules.size());
            for (ModifierModule.ModuleWithHooks module : object.modules) {
                module.toNetwork(buffer);
            }
        }
    };

    protected ComposableModifier(ModifierLevelDisplay levelDisplay, TooltipDisplay tooltipDisplay, int priority, List<ModifierModule.ModuleWithHooks> modules) {
        super(ModifierModule.createMap(modules));
        this.levelDisplay = levelDisplay;
        this.tooltipDisplay = tooltipDisplay;
        this.priority = priority;
        this.modules = modules;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public GenericLoaderRegistry.IGenericLoader<? extends Modifier> getLoader() {
        return LOADER;
    }

    @Override
    protected final void registerHooks(ModifierHookMap.Builder hookBuilder) {
    }

    @Override
    public class_2561 getDisplayName(int level) {
        return this.levelDisplay.nameForLevel(this, level);
    }

    @Override
    public class_2561 getDisplayName(IToolStackView tool, int level) {
        return this.getHook(TinkerHooks.DISPLAY_NAME).getDisplayName(tool, this, level, this.getDisplayName(level));
    }

    @Override
    public float getEffectiveLevel(IToolContext tool, int level) {
        return this.getHook(TinkerHooks.EFFECTIVE_LEVEL).getEffectiveLevel(tool, this, level);
    }

    @Override
    public boolean shouldDisplay(boolean advanced) {
        return advanced ? this.tooltipDisplay != TooltipDisplay.NEVER : this.tooltipDisplay == TooltipDisplay.ALWAYS;
    }

    private static int computePriority(List<ModifierModule.ModuleWithHooks> modules) {
        ArrayList<ModifierModule> priorityModules = new ArrayList<ModifierModule>();
        for (ModifierModule.ModuleWithHooks module2 : modules) {
            if (module2.module().getPriority() == null) continue;
            priorityModules.add(module2.module());
        }
        if (!priorityModules.isEmpty()) {
            int firstPriority = ((ModifierModule)priorityModules.get(0)).getPriority();
            for (int i = 1; i < priorityModules.size(); ++i) {
                if (((ModifierModule)priorityModules.get(i)).getPriority() == firstPriority) continue;
                TConstruct.LOG.warn("Multiple modules disagree on the preferred priority for composable modifier, choosing priority {}. Set the priority manually to silence this warning. All opinions: \n{}", (Object)firstPriority, (Object)priorityModules.stream().map(module -> "* " + module + ": " + module.getPriority()).collect(Collectors.joining("\n")));
                break;
            }
            return firstPriority;
        }
        return 100;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public static enum TooltipDisplay {
        ALWAYS,
        TINKER_STATION,
        NEVER;

    }

    public static class Builder {
        private ModifierLevelDisplay levelDisplay = ModifierLevelDisplay.DEFAULT;
        private TooltipDisplay tooltipDisplay = TooltipDisplay.ALWAYS;
        private int priority = Integer.MIN_VALUE;
        private final ImmutableList.Builder<ModifierModule.ModuleWithHooks> modules = ImmutableList.builder();

        public final <T extends ModifierModule> Builder addModule(T object) {
            this.modules.add((Object)new ModifierModule.ModuleWithHooks(object, Collections.emptyList()));
            return this;
        }

        @SafeVarargs
        public final <T extends ModifierModule> Builder addModule(T object, ModifierHook<? super T> ... hooks) {
            this.modules.add((Object)new ModifierModule.ModuleWithHooks(object, List.of(hooks)));
            return this;
        }

        public ComposableModifier build() {
            ImmutableList modules = this.modules.build();
            if (this.priority == Integer.MIN_VALUE) {
                ComposableModifier.computePriority((List<ModifierModule.ModuleWithHooks>)modules);
            }
            return new ComposableModifier(this.levelDisplay, this.tooltipDisplay, this.priority, (List<ModifierModule.ModuleWithHooks>)modules);
        }

        private Builder() {
        }

        public Builder levelDisplay(ModifierLevelDisplay levelDisplay) {
            this.levelDisplay = levelDisplay;
            return this;
        }

        public Builder tooltipDisplay(TooltipDisplay tooltipDisplay) {
            this.tooltipDisplay = tooltipDisplay;
            return this;
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }
    }
}

